/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.api;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.yagaan.scanner.api.AbstractRequest;
import com.yagaan.scanner.api.AbstractRequestWithBody;
import com.yagaan.scanner.http.HttpConnector;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class AbstractRestService {
    protected HttpConnector connector;
    protected static final Gson GSON = AbstractRestService.gson();

    public AbstractRestService(HttpConnector connector) {
        this.connector = connector;
    }

    private static Gson gson() {
        GsonBuilder builder = new GsonBuilder();
        DateTimeFormatter format = DateTimeFormatter.ISO_DATE_TIME;
        builder.registerTypeAdapter(Instant.class, (Object)new /* Unavailable Anonymous Inner Class!! */);
        return builder.create();
    }

    protected Request.Builder requestBuilder() {
        Request.Builder builder = new Request.Builder();
        this.connector.authenticate(builder);
        return builder;
    }

    protected Request.Builder get(AbstractRequest request) {
        Request.Builder builder = this.requestBuilder();
        builder.url(this.requestUrl(request).build());
        return builder.get();
    }

    protected Request.Builder postForm(AbstractRequest request) {
        Request.Builder builder = this.requestBuilder();
        String path = this.requestPath(request);
        builder.url(this.connector.url(path).build());
        FormBody.Builder bodyBuilder = new FormBody.Builder();
        for (Map.Entry param : request.getParameters().entrySet()) {
            bodyBuilder.add((String)param.getKey(), (String)param.getValue());
        }
        return builder.post((RequestBody)bodyBuilder.build());
    }

    protected Request.Builder post(AbstractRequestWithBody<?> request) {
        Request.Builder builder = this.requestBuilder();
        builder.url(this.requestUrl(request).build());
        String json = GSON.toJson(request.getBody());
        RequestBody body = RequestBody.create((MediaType)MediaType.get((String)"application/json"), (String)json);
        return builder.post(body);
    }

    protected Request.Builder delete(AbstractRequest request) {
        Request.Builder builder = this.requestBuilder();
        builder.url(this.requestUrl(request).build());
        return builder.delete();
    }

    protected <T> T body(Response response, Type type) {
        return (T)GSON.fromJson(response.body().charStream(), type);
    }

    protected String requestPath(AbstractRequest request) {
        String path = request.getPath();
        for (Map.Entry e : request.getSegments().entrySet()) {
            path = path.replace("{" + (String)e.getKey() + "}", (CharSequence)e.getValue());
        }
        return path;
    }

    protected HttpUrl.Builder requestUrl(AbstractRequest request) {
        String path = this.requestPath(request);
        HttpUrl.Builder url = this.connector.url(path);
        for (Map.Entry e : request.getParameters().entrySet()) {
            url.addQueryParameter((String)e.getKey(), (String)e.getValue());
        }
        return url;
    }

    protected String error(Response response) {
        String message = response.message();
        if (!Strings.isNullOrEmpty((String)message)) {
            return message;
        }
        try {
            String body = response.body().string();
            HashMap fromJson = (HashMap)new Gson().fromJson(body, HashMap.class);
            return (String)fromJson.get("title");
        }
        catch (Exception body) {
            String errorHeader = response.header("X-yfpApp-error");
            if (!Strings.isNullOrEmpty((String)errorHeader)) {
                return errorHeader;
            }
            return "status code: " + response.code();
        }
    }
}

