/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.api;

import com.yagaan.scanner.api.account.AccessTokenService;
import com.yagaan.scanner.api.account.AccountService;
import com.yagaan.scanner.api.authentication.AuthenticationRequest;
import com.yagaan.scanner.api.authentication.AuthenticationService;
import com.yagaan.scanner.api.authentication.Credentials;
import com.yagaan.scanner.api.authentication.JWTToken;
import com.yagaan.scanner.api.gates.GateService;
import com.yagaan.scanner.api.group.GroupService;
import com.yagaan.scanner.api.issues.IssuesService;
import com.yagaan.scanner.api.products.AuditCenterService;
import com.yagaan.scanner.api.project.ProjectService;
import com.yagaan.scanner.api.resources.ResourceService;
import com.yagaan.scanner.api.rules.RulesService;
import com.yagaan.scanner.http.HttpConnector;
import java.net.ConnectException;
import java.util.Optional;

public class YagaanRestClient {
    private final HttpConnector connector;

    public YagaanRestClient(HttpConnector connector) {
        this.connector = connector;
    }

    public YagaanRestClient(String url, String personalAccessToken) throws ConnectException {
        this(url, personalAccessToken, personalAccessToken);
    }

    public YagaanRestClient(String url, String user, String password) throws ConnectException {
        if (url == null) {
            throw new ConnectException("Unable to connect. Require a server url");
        }
        if (user == null) {
            throw new ConnectException("Unable to connect. Require a username");
        }
        if (password == null) {
            throw new ConnectException("Unable to connect. Require a password");
        }
        HttpConnector firstConnector = new HttpConnector.ConnectorBuilder(url).build();
        AuthenticationService auth = new AuthenticationService(firstConnector);
        Optional token = auth.authenticate(new AuthenticationRequest(new Credentials(user, password)));
        if (!token.isPresent()) {
            throw new ConnectException("Unable to connect to " + url);
        }
        this.connector = new HttpConnector.ConnectorBuilder(url).token(((JWTToken)token.get()).getIdToken()).build();
    }

    public AccountService account() {
        return new AccountService(this.connector);
    }

    public AccessTokenService accessTokens() {
        return new AccessTokenService(this.connector);
    }

    public AuthenticationService auth() {
        return new AuthenticationService(this.connector);
    }

    public ResourceService resources() {
        return new ResourceService(this.connector);
    }

    public GroupService group() {
        return new GroupService(this.connector);
    }

    public ProjectService project() {
        return new ProjectService(this.connector);
    }

    public IssuesService issues() {
        return new IssuesService(this.connector);
    }

    public RulesService rules() {
        return new RulesService(this.connector);
    }

    public GateService gate() {
        return new GateService(this.connector);
    }

    public AuditCenterService auditCenter() {
        return new AuditCenterService(this.connector);
    }
}

