/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.api.account;

import com.yagaan.scanner.api.AbstractRequest;
import com.yagaan.scanner.api.AbstractRequestWithBody;
import com.yagaan.scanner.api.AbstractRestService;
import com.yagaan.scanner.api.account.AccessToken;
import com.yagaan.scanner.api.account.CreateAccessTokenRequest;
import com.yagaan.scanner.api.account.RevokeAccessTokenRequest;
import com.yagaan.scanner.http.HttpConnector;
import java.time.Instant;
import java.util.Optional;
import okhttp3.Request;
import okhttp3.Response;

public class AccessTokenService
extends AbstractRestService {
    public AccessTokenService(HttpConnector connector) {
        super(connector);
    }

    public Optional<AccessToken> newAccessToken(String name, Instant expiration) {
        Request httpRequest = this.post((AbstractRequestWithBody)new CreateAccessTokenRequest(name, expiration)).build();
        try (Response response = this.connector.call(httpRequest);){
            if (response.isSuccessful()) {
                Optional<AccessToken> optional = Optional.of((AccessToken)this.body(response, AccessToken.class));
                return optional;
            }
        }
        return Optional.empty();
    }

    public void revoke(long tokenId) {
        Request httpRequest = this.delete((AbstractRequest)new RevokeAccessTokenRequest(tokenId)).build();
        this.connector.call(httpRequest);
    }
}

