/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.api.account;

import com.google.gson.Gson;
import com.yagaan.scanner.api.AbstractRequest;
import com.yagaan.scanner.api.AbstractRestService;
import com.yagaan.scanner.api.account.DownloadDefaultScanRepositoryRequest;
import com.yagaan.scanner.api.account.UsernameRequest;
import com.yagaan.scanner.api.authentication.LicenseRequest;
import com.yagaan.scanner.api.authentication.LicenseToken;
import com.yagaan.scanner.http.HttpConnector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;

public class AccountService
extends AbstractRestService {
    public AccountService(HttpConnector connector) {
        super(connector);
    }

    public void downloadRepository(Path file) throws IOException {
        Request httpRequest = this.get((AbstractRequest)new DownloadDefaultScanRepositoryRequest()).build();
        try (Response response = this.connector.call(httpRequest);
             OutputStream output = Files.newOutputStream(file, new OpenOption[0]);
             InputStream stream = response.body().byteStream();){
            IOUtils.copy((InputStream)stream, (OutputStream)output);
        }
    }

    public Optional<String> username() {
        Request httpRequest = this.get((AbstractRequest)new UsernameRequest()).build();
        try (Response response = this.connector.call(httpRequest);){
            if (response.isSuccessful()) {
                try {
                    Optional<String> optional = Optional.of(response.body().string());
                    return optional;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return Optional.empty();
    }

    public Optional<LicenseToken> license() {
        Request httpRequest = this.get((AbstractRequest)new LicenseRequest()).build();
        try (Response response = this.connector.call(httpRequest);){
            if (response.isSuccessful()) {
                try {
                    String json = response.body().string();
                    Optional<LicenseToken> optional = Optional.of((LicenseToken)new Gson().fromJson(json, LicenseToken.class));
                    return optional;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return Optional.empty();
    }
}

