/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.api.authentication;

import com.google.gson.Gson;
import com.yagaan.scanner.api.AbstractRequest;
import com.yagaan.scanner.api.AbstractRequestWithBody;
import com.yagaan.scanner.api.AbstractRestService;
import com.yagaan.scanner.api.account.UsernameRequest;
import com.yagaan.scanner.api.authentication.AuthenticationRequest;
import com.yagaan.scanner.api.authentication.JWTToken;
import com.yagaan.scanner.api.authentication.LicenseRequest;
import com.yagaan.scanner.api.authentication.LicenseToken;
import com.yagaan.scanner.http.HttpConnector;
import java.io.IOException;
import java.util.Optional;
import okhttp3.Request;
import okhttp3.Response;

public class AuthenticationService
extends AbstractRestService {
    public AuthenticationService(HttpConnector connector) {
        super(connector);
    }

    public Optional<JWTToken> authenticate(AuthenticationRequest request) {
        Request httpRequest = this.post((AbstractRequestWithBody)request).build();
        try (Response response = this.connector.call(httpRequest);){
            String header;
            if (response.isSuccessful() && (header = response.header("Authorization")) != null && header.startsWith("Bearer ")) {
                String token = header.substring(7);
                Optional<JWTToken> optional = Optional.of(new JWTToken(token));
                return optional;
            }
        }
        return Optional.empty();
    }

    @Deprecated
    public Optional<String> username() {
        Request httpRequest = this.get((AbstractRequest)new UsernameRequest()).build();
        try (Response response = this.connector.call(httpRequest);){
            if (response.isSuccessful()) {
                try {
                    Optional<String> optional = Optional.of(response.body().string());
                    return optional;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return Optional.empty();
    }

    @Deprecated
    public Optional<LicenseToken> license() {
        Request httpRequest = this.get((AbstractRequest)new LicenseRequest()).build();
        try (Response response = this.connector.call(httpRequest);){
            if (response.isSuccessful()) {
                try {
                    String json = response.body().string();
                    Optional<LicenseToken> optional = Optional.of((LicenseToken)new Gson().fromJson(json, LicenseToken.class));
                    return optional;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return Optional.empty();
    }
}

