/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.api.gates;

import com.yagaan.scanner.api.project.Summary;
import com.yagaan.scanner.scan.SecurityGateException;

public class ScanGate {
    private int maxScore = -1;
    private int maxHigh = -1;
    private int maxModerate = -1;
    private int maxLow = -1;

    public int getMaxScore() {
        return this.maxScore;
    }

    public void setMaxScore(int maxScore) {
        this.maxScore = maxScore;
    }

    public int getMaxHigh() {
        return this.maxHigh;
    }

    public void setMaxHigh(int maxHigh) {
        this.maxHigh = maxHigh;
    }

    public int getMaxModerate() {
        return this.maxModerate;
    }

    public void setMaxModerate(int maxModerate) {
        this.maxModerate = maxModerate;
    }

    public int getMaxLow() {
        return this.maxLow;
    }

    public void setMaxLow(int maxLow) {
        this.maxLow = maxLow;
    }

    public void check(Summary summary) throws SecurityGateException {
        this.check("Security risk", ((Integer)summary.getRisk().getValue()).intValue(), this.maxScore);
        this.check("Amount of high severity vulnerabilities", ((Integer)summary.getCritical().getValue()).intValue(), this.maxHigh);
        this.check("Amount of moderate severity vulnerabilities", ((Integer)summary.getMajor().getValue()).intValue(), this.maxModerate);
        this.check("Amount of low severity vulnerabilities", ((Integer)summary.getMinor().getValue()).intValue(), this.maxHigh);
    }

    private void check(String constraint, int value, int max) throws SecurityGateException {
        if (max >= 0 && value > max) {
            throw new SecurityGateException(String.format("%s : %d > %d", constraint, value, this.maxHigh));
        }
    }

    public String toString() {
        return "ScanGate [maxScore=" + this.maxScore + ", maxHigh=" + this.maxHigh + ", maxModerate=" + this.maxModerate + ", maxLow=" + this.maxLow + "]";
    }
}

