/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.api.issues;

import com.google.common.collect.ImmutableList;
import com.yagaan.scanner.api.AbstractRequest;
import com.yagaan.scanner.api.AbstractRestService;
import com.yagaan.scanner.api.PageableBody;
import com.yagaan.scanner.api.issues.BestFix;
import com.yagaan.scanner.api.issues.Diagnostic;
import com.yagaan.scanner.api.issues.Issue;
import com.yagaan.scanner.api.issues.IssuesService;
import com.yagaan.scanner.api.issues.PropagationPath;
import com.yagaan.scanner.api.issues.Remediations;
import com.yagaan.scanner.http.HttpConnector;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import okhttp3.Request;
import okhttp3.Response;

public class IssuesService
extends AbstractRestService {
    public IssuesService(HttpConnector connector) {
        super(connector);
    }

    public List<Issue> findAll(long project, boolean withHash, int minBelief) {
        FindAllIssuesRequest issuesRequest = new FindAllIssuesRequest();
        issuesRequest.setMinBelief(minBelief);
        issuesRequest.setProject(project);
        issuesRequest.setWithHash(withHash);
        try (Response response = this.connector.call(this.get((AbstractRequest)issuesRequest).build());){
            if (response.isSuccessful()) {
                Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
                List list = (List)this.body(response, type);
                return list;
            }
            throw new IllegalStateException("Call to API failed with status code " + response.code());
        }
    }

    public List<Issue> find(long project, @Nullable String severities, @Nullable String rules, @Nullable String tags, boolean withHash, @Nullable String filter) {
        FindIssuesRequest issuesRequest = new FindIssuesRequest();
        if (filter != null) {
            issuesRequest.setFilter(filter);
        }
        return this.find((AbstractFindIssuesRequest)issuesRequest, project, severities, rules, tags, withHash);
    }

    public List<Issue> findInFile(long project, @Nullable String severities, @Nullable String rules, @Nullable String tags, boolean withHash, String filePath) {
        FindIssuesInFileRequest issuesRequest = new FindIssuesInFileRequest(filePath);
        return this.find((AbstractFindIssuesRequest)issuesRequest, project, severities, rules, tags, withHash);
    }

    public List<Issue> findInFiles(long project, @Nullable String severities, @Nullable String rules, @Nullable String tags, boolean withHash, List<String> filePaths) {
        FindIssuesInFilesRequest issuesRequest = new FindIssuesInFilesRequest(filePaths);
        return this.find((AbstractFindIssuesRequest)issuesRequest, project, severities, rules, tags, withHash);
    }

    private List<Issue> find(AbstractFindIssuesRequest issuesRequest, long project, String severities, String rules, String tags, boolean withHash) {
        issuesRequest.setProject(project);
        if (severities != null) {
            issuesRequest.setSeverities(severities);
        }
        if (rules != null) {
            issuesRequest.setRules(rules);
        }
        if (tags != null) {
            issuesRequest.setTags(tags);
        }
        issuesRequest.setWithHash(withHash);
        issuesRequest.setSize(500);
        boolean finished = false;
        ArrayList<Issue> issues = new ArrayList<Issue>();
        do {
            String getURL;
            Request getRequest = this.get((AbstractRequest)issuesRequest).build();
            Request request = issuesRequest instanceof FindIssuesInFilesRequest ? ((getURL = getRequest.url().toString()).length() > 2000 ? this.postForm((AbstractRequest)issuesRequest).build() : getRequest) : getRequest;
            try (Response response = this.connector.call(request);){
                if (response.isSuccessful()) {
                    Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
                    PageableBody pageable = (PageableBody)this.body(response, type);
                    finished = pageable.isLast();
                    if (pageable.isFirst() && pageable.isLast()) {
                        List list = pageable.getContent();
                        return list;
                    }
                    issues.addAll(pageable.getContent());
                    issuesRequest.setPage(pageable.getNumber() + 1);
                    continue;
                }
                throw new IllegalStateException("Call to API failed with status code " + response.code());
            }
        } while (!finished);
        return issues;
    }

    public Optional<Diagnostic> diagnostic(long project, String issue) {
        Request request = this.get((AbstractRequest)new IssueRequest("api/issues/diagnostic", project, issue)).build();
        try (Response response = this.connector.call(request);){
            Diagnostic diag;
            if (response.isSuccessful() && (diag = (Diagnostic)this.body(response, Diagnostic.class)).getRule() != null) {
                Optional<Diagnostic> optional = Optional.of(diag);
                return optional;
            }
        }
        return Optional.empty();
    }

    public Optional<BestFix> bestfix(long project, String issue, boolean global) {
        IssueRequest ir = new IssueRequest("api/issues/bestfix", project, issue);
        ir.setParameter("global", Boolean.toString(global));
        Request request = this.get((AbstractRequest)ir).build();
        try (Response response = this.connector.call(request);){
            if (response.isSuccessful()) {
                BestFix diag = (BestFix)this.body(response, BestFix.class);
                Optional<BestFix> optional = Optional.of(diag);
                return optional;
            }
        }
        return Optional.empty();
    }

    public Optional<Remediations> remediations(long project, String issue) {
        Request request = this.get((AbstractRequest)new IssueRequest("api/issues/remediations", project, issue)).build();
        try (Response response = this.connector.call(request);){
            Remediations diag;
            if (response.isSuccessful() && !(diag = (Remediations)this.body(response, Remediations.class)).getRemediations().isEmpty()) {
                Optional<Remediations> optional = Optional.of(diag);
                return optional;
            }
        }
        return Optional.empty();
    }

    public List<PropagationPath> paths(long project, String issue) {
        Request request = this.get((AbstractRequest)new IssueRequest("api/issues/paths", project, issue)).build();
        try (Response response = this.connector.call(request);){
            if (response.isSuccessful()) {
                Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
                List list = (List)this.body(response, type);
                return list;
            }
        }
        return ImmutableList.of();
    }
}

