/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.api.products;

import com.yagaan.scanner.api.AbstractRequest;
import com.yagaan.scanner.api.AbstractRestService;
import com.yagaan.scanner.api.products.AuditCenterChangelogRequest;
import com.yagaan.scanner.api.products.AuditCenterVersionRequest;
import com.yagaan.scanner.api.products.DownloadAuditCenterRequest;
import com.yagaan.scanner.api.products.DownloadAuditCenterUpdateRequest;
import com.yagaan.scanner.http.HttpConnector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditCenterService
extends AbstractRestService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditCenterService.class);

    public AuditCenterService(HttpConnector connector) {
        super(connector);
    }

    public String version() throws IOException {
        Request request = this.get((AbstractRequest)new AuditCenterVersionRequest()).build();
        try (Response response = this.connector.call(request);){
            if (response.isSuccessful()) {
                String string = response.body().string();
                return string;
            }
            LOGGER.warn("Unable to get latest audit center version: {}", (Object)this.error(response));
            String string = "";
            return string;
        }
    }

    public String changlog() throws IOException {
        Request request = this.get((AbstractRequest)new AuditCenterChangelogRequest()).build();
        try (Response response = this.connector.call(request);){
            if (response.isSuccessful()) {
                String string = response.body().string();
                return string;
            }
            LOGGER.warn("Unable to get latest audit center changelog: {}", (Object)this.error(response));
            String string = "";
            return string;
        }
    }

    public void download(File output, String os) throws IOException {
        block12: {
            Request request = this.get((AbstractRequest)new DownloadAuditCenterRequest(os)).build();
            try (Response response = this.connector.call(request);){
                if (!response.isSuccessful()) {
                    LOGGER.warn("Unable to download audit center for os: {}", (Object)this.error(response));
                    break block12;
                }
                try (FileOutputStream outputStream = new FileOutputStream(output);){
                    IOUtils.copyLarge((InputStream)response.body().byteStream(), (OutputStream)outputStream);
                }
            }
        }
    }

    public void downloadUpdateSite(File output) throws IOException {
        Request request = this.get((AbstractRequest)new DownloadAuditCenterUpdateRequest()).build();
        try (Response response = this.connector.call(request);){
            try (FileOutputStream outputStream = new FileOutputStream(output);){
                IOUtils.copyLarge((InputStream)response.body().byteStream(), (OutputStream)outputStream);
            }
            if (!response.isSuccessful()) {
                LOGGER.warn("Unable to download audit center for os: {}", (Object)this.error(response));
            }
        }
    }
}

