/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.api.project;

import com.yagaan.scanner.api.AbstractRequest;
import com.yagaan.scanner.api.AbstractRequestWithBody;
import com.yagaan.scanner.api.AbstractRestService;
import com.yagaan.scanner.api.project.CreateProjectRequest;
import com.yagaan.scanner.api.project.DeleteProjectRequest;
import com.yagaan.scanner.api.project.FindProjectRequest;
import com.yagaan.scanner.api.project.GetAllProjectsRequest;
import com.yagaan.scanner.api.project.GetProjectSummaryRequest;
import com.yagaan.scanner.api.project.Project;
import com.yagaan.scanner.api.project.ProjectException;
import com.yagaan.scanner.api.project.ProjectService;
import com.yagaan.scanner.api.project.QueryProjectRequest;
import com.yagaan.scanner.api.project.QueryResults;
import com.yagaan.scanner.api.project.RemoteScanAccessDetailsRequest;
import com.yagaan.scanner.api.project.ScanAccessDetails;
import com.yagaan.scanner.api.project.ScanProgressRequest;
import com.yagaan.scanner.api.project.ScanProjectRequest;
import com.yagaan.scanner.api.project.Summary;
import com.yagaan.scanner.api.project.UploadProjectRequest;
import com.yagaan.scanner.api.scm.ISourceConnector;
import com.yagaan.scanner.api.scm.SourceConfigurationPropertyBuilder;
import com.yagaan.scanner.api.scm.UploadedFile;
import com.yagaan.scanner.api.settings.SettingsService;
import com.yagaan.scanner.api.settings.UpdateProjectSettingsRequest;
import com.yagaan.scanner.http.HttpConnector;
import com.yagaan.scanner.scan.ScanException;
import com.yagaan.scanner.scan.ScanStatus;
import io.reactivex.Notification;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.observables.ConnectableObservable;
import io.reactivex.subjects.PublishSubject;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProjectService
extends AbstractRestService {
    private int refreshInMillis = 5000;
    private int scanWithoutUpdateTimeoutInMillis = 600000;

    public ProjectService(HttpConnector connector) {
        super(connector);
    }

    public void setRefreshInMillis(int refreshInMillis) {
        this.refreshInMillis = refreshInMillis;
    }

    public void setScanWithoutUpdateTimeoutInMillis(int scanWithoutUpdateTimeoutInMillis) {
        this.scanWithoutUpdateTimeoutInMillis = scanWithoutUpdateTimeoutInMillis;
    }

    public ScanStatus scan(Project project) {
        Request request = this.get((AbstractRequest)new ScanProjectRequest(project)).build();
        try (Response response = this.connector.call(request);){
            if (response.isSuccessful()) {
                ScanStatus scanStatus = (ScanStatus)this.body(response, ScanStatus.class);
                return scanStatus;
            }
            throw new ProjectException("Unable to scan project " + project.getName() + ": " + this.error(response));
        }
    }

    public Summary scanWithResults(Project project, Consumer<? super Notification<ScanStatus>> statusListener) {
        this.scan(project);
        PublishSubject progress = this.progress(project);
        ScanStatus last = (ScanStatus)progress.doOnEach(statusListener).blockingLast();
        if (last.getState() == ScanStatus.State.FAILURE || last.getState() == ScanStatus.State.CANCEL || last.getState() == ScanStatus.State.REJECTED) {
            throw new ProjectException("Project has not been successfully scanned");
        }
        Summary summary = this.summary(project);
        if (summary.getStatus().getState() != ScanStatus.State.SUCCESS) {
            throw new ProjectException("Project has not been successfully scanned");
        }
        return summary;
    }

    public QueryResults query(Project project, String query) {
        Request request = this.post((AbstractRequestWithBody)new QueryProjectRequest(project, query)).build();
        try (Response response = this.connector.call(request);){
            if (response.isSuccessful()) {
                QueryResults queryResults = (QueryResults)this.body(response, QueryResults.class);
                return queryResults;
            }
            String error = this.error(response);
            throw new ProjectException("Unable to query project " + project.getName() + ": " + error);
        }
    }

    public ScanStatus status(Project project) {
        Request request = this.get((AbstractRequest)new ScanProgressRequest(project)).build();
        try (Response response = this.connector.call(request);){
            if (response.isSuccessful()) {
                ScanStatus scanStatus = (ScanStatus)this.body(response, ScanStatus.class);
                return scanStatus;
            }
            throw new ProjectException("Unable to get scan progress of project " + project.getName() + ": " + this.error(response));
        }
    }

    public Summary summary(Project project) {
        Request request = this.get((AbstractRequest)new GetProjectSummaryRequest(project)).build();
        try (Response response = this.connector.call(request);){
            if (response.isSuccessful()) {
                Summary summary = (Summary)this.body(response, Summary.class);
                return summary;
            }
            throw new ProjectException("Unable to get scan summary of project " + project.getName() + ": " + this.error(response));
        }
    }

    public PublishSubject<ScanStatus> progress(Project project) {
        PublishSubject subject = PublishSubject.create();
        ConnectableObservable refresh = Observable.interval((long)this.refreshInMillis, (TimeUnit)TimeUnit.MILLISECONDS).publish();
        int maxUnchangedState = 5;
        if (this.refreshInMillis < this.scanWithoutUpdateTimeoutInMillis) {
            maxUnchangedState = this.scanWithoutUpdateTimeoutInMillis / this.refreshInMillis;
        }
        Disposable connect = refresh.connect();
        MaxUnchangedStatePredicate maxUnchangedStatePredicate = new MaxUnchangedStatePredicate(maxUnchangedState);
        MaxCommunicationsErrorCounter errorCounter = new MaxCommunicationsErrorCounter(5);
        refresh.subscribe(tick -> {
            block11: {
                if (!connect.isDisposed()) {
                    try {
                        ScanStatus status = this.status(project);
                        errorCounter.reset();
                        if (maxUnchangedStatePredicate.test(status)) {
                            ScanStatus.State state = status.getState();
                            if (state == ScanStatus.State.CANCEL || state == ScanStatus.State.SUCCESS || state == ScanStatus.State.REJECTED) {
                                subject.onNext((Object)status);
                                subject.onComplete();
                                connect.dispose();
                            } else if (state == ScanStatus.State.NOTRUNNING) {
                                subject.onComplete();
                                connect.dispose();
                            } else if (state == ScanStatus.State.FAILURE) {
                                subject.onError((Throwable)new ScanException(status.getMessage()));
                                connect.dispose();
                            } else {
                                subject.onNext((Object)status);
                            }
                        } else {
                            int duration = MaxUnchangedStatePredicate.access$000((MaxUnchangedStatePredicate)maxUnchangedStatePredicate) * this.refreshInMillis;
                            subject.onError((Throwable)new ScanException("Timeout: scan status or progress has not changed since " + duration + " ms."));
                            connect.dispose();
                        }
                    }
                    catch (Exception e) {
                        if (errorCounter.increment()) break block11;
                        subject.onError((Throwable)e);
                        connect.dispose();
                    }
                }
            }
        });
        return subject;
    }

    public ScanAccessDetails remote(Project project) {
        return this.remote(project.getId());
    }

    public ScanAccessDetails remote(Long pid) {
        Request request = this.get((AbstractRequest)new RemoteScanAccessDetailsRequest(pid)).build();
        try (Response response = this.connector.call(request);){
            if (response.isSuccessful()) {
                ScanAccessDetails scanAccessDetails = (ScanAccessDetails)this.body(response, ScanAccessDetails.class);
                return scanAccessDetails;
            }
            throw new ProjectException("Unable to get remote access details for project " + pid + ": " + this.error(response));
        }
    }

    public void scm(Project project, ISourceConnector scm) {
        List properties = new SourceConfigurationPropertyBuilder(project).connector(scm).build();
        UpdateProjectSettingsRequest request = new UpdateProjectSettingsRequest(project, properties);
        new SettingsService(this.connector).update(request);
    }

    public UploadedFile upload(UploadProjectRequest request) {
        Request.Builder builder = this.requestBuilder();
        builder.url(this.requestUrl((AbstractRequest)request).build());
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        RequestBody file = RequestBody.create((MediaType)MediaType.parse((String)"application/zip"), (File)request.getFile());
        bodyBuilder.addFormDataPart("file", request.getFile().getName(), file);
        Request httpRequest = builder.post((RequestBody)bodyBuilder.build()).build();
        try (Response response = this.connector.call(httpRequest);){
            if (response.isSuccessful()) {
                UploadedFile uploadedFile = (UploadedFile)this.body(response, UploadedFile.class);
                return uploadedFile;
            }
            throw new ProjectException("Unable to upload code: " + this.error(response));
        }
    }

    public InputStream download(long id) {
        Request request = this.get((AbstractRequest)new /* Unavailable Anonymous Inner Class!! */).build();
        Response response = this.connector.call(request);
        if (!response.isSuccessful()) {
            response.close();
            throw new ProjectException("Unable to download project: " + this.error(response));
        }
        return response.body().byteStream();
    }

    public void deleteProject(Project project) {
        if (project.getId() == null) {
            throw new IllegalArgumentException("Expecting a project with an identifier");
        }
        Request request = this.delete((AbstractRequest)new DeleteProjectRequest(project)).build();
        try (Response response = this.connector.call(request);){
            if (!response.isSuccessful()) {
                throw new ProjectException("Unable to delete project: " + this.error(response));
            }
        }
    }

    public Optional<Project> find(String name) {
        Request request = this.get((AbstractRequest)new FindProjectRequest(name)).build();
        try (Response response = this.connector.call(request);){
            if (response.isSuccessful()) {
                Optional<Project> optional = Optional.of((Project)this.body(response, Project.class));
                return optional;
            }
        }
        return Optional.empty();
    }

    public Project getOrCreate(Project project) {
        Optional oproject = this.find(project.getName());
        if (oproject.isPresent()) {
            return (Project)oproject.get();
        }
        return this.create(project);
    }

    public Project create(Project project) {
        if (project.getGroupId() == null) {
            throw new IllegalStateException("Project must have a group identifier");
        }
        Request request = this.post((AbstractRequestWithBody)new CreateProjectRequest(project)).build();
        try (Response response = this.connector.call(request);){
            if (response.isSuccessful()) {
                Project project2 = (Project)this.body(response, Project.class);
                return project2;
            }
            throw new ProjectException("Unable to create project " + project.getName() + ": " + this.error(response));
        }
    }

    public List<Project> getAll() {
        Request request = this.get((AbstractRequest)new GetAllProjectsRequest()).build();
        try (Response response = this.connector.call(request);){
            if (response.isSuccessful()) {
                Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
                List list = (List)this.body(response, type);
                return list;
            }
        }
        return Collections.emptyList();
    }
}

