/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.api.rules;

import com.yagaan.scanner.api.AbstractRequest;
import com.yagaan.scanner.api.AbstractRequestWithBody;
import com.yagaan.scanner.api.AbstractRestService;
import com.yagaan.scanner.api.issues.ScanRuleDetails;
import com.yagaan.scanner.api.project.ProfileException;
import com.yagaan.scanner.api.rules.DownloadScanRepositoryRequest;
import com.yagaan.scanner.api.rules.GetProjectScanRepositoryRequest;
import com.yagaan.scanner.api.rules.ListAvailableScanRepositoriesRequest;
import com.yagaan.scanner.api.rules.RuleDetailsRequest;
import com.yagaan.scanner.api.rules.ScanRepositoryDescrition;
import com.yagaan.scanner.api.rules.SelectProjectScanRepositoryRequest;
import com.yagaan.scanner.api.rules.UploadScanRepositoryRequest;
import com.yagaan.scanner.http.HttpConnector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class RulesService
extends AbstractRestService {
    public RulesService(HttpConnector connector) {
        super(connector);
    }

    public List<ScanRepositoryDescrition> listScanRepositories() {
        ListAvailableScanRepositoriesRequest request = new ListAvailableScanRepositoriesRequest();
        try (Response response = this.connector.call(this.get((AbstractRequest)request).build());){
            if (response.isSuccessful()) {
                Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
                List list = (List)this.body(response, type);
                return list;
            }
            throw new IllegalStateException("Call to API failed with status code " + response.code());
        }
    }

    public Optional<ScanRuleDetails> details(long projectId, String rule) {
        RuleDetailsRequest request = new RuleDetailsRequest(projectId, rule);
        try (Response response = this.connector.call(this.get((AbstractRequest)request).build());){
            if (response.isSuccessful()) {
                Optional<ScanRuleDetails> optional = Optional.of((ScanRuleDetails)this.body(response, ScanRuleDetails.class));
                return optional;
            }
            if (response.code() == 404) {
                Optional<ScanRuleDetails> optional = Optional.empty();
                return optional;
            }
            throw new IllegalStateException("Call to API failed with status code " + response.code());
        }
    }

    public void select(SelectProjectScanRepositoryRequest request) {
        try (Response response = this.connector.call(this.post((AbstractRequestWithBody)request).build());){
            if (!response.isSuccessful()) {
                throw new IllegalStateException("Call to API failed with status code " + response.code());
            }
        }
    }

    public Optional<ScanRepositoryDescrition> getProjectRepository(Long pid) {
        try (Response response = this.connector.call(this.get((AbstractRequest)new GetProjectScanRepositoryRequest(pid)).build());){
            if (response.isSuccessful()) {
                Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
                Optional<ScanRepositoryDescrition> optional = Optional.ofNullable((ScanRepositoryDescrition)this.body(response, type));
                return optional;
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(UploadScanRepositoryRequest request) {
        try {
            Path tmpDir = Files.createTempDirectory("", new FileAttribute[0]);
            File tmpZip = tmpDir.resolve("repository.zip").toFile();
            this.zip(request.getFile(), tmpZip);
            Request.Builder builder = this.requestBuilder();
            builder.url(this.requestUrl((AbstractRequest)request).build());
            MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
            RequestBody file = RequestBody.create((MediaType)MediaType.parse((String)"application/zip"), (File)tmpZip);
            bodyBuilder.addFormDataPart("file", request.getFile().getName(), file);
            Request httpRequest = builder.post((RequestBody)bodyBuilder.build()).build();
            try (Response response = this.connector.call(httpRequest);){
                if (!response.isSuccessful()) {
                    throw new ProfileException("Unable to upload scanned rules profile: " + this.error(response));
                }
            }
            finally {
                FileUtils.deleteQuietly((File)tmpDir.toFile());
            }
        }
        catch (IOException e) {
            throw new ProfileException("Unable to create temp file to zip the repository", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadRepository(DownloadScanRepositoryRequest request) {
        Request httpRequest = this.get((AbstractRequest)request).build();
        try (Response response = this.connector.call(httpRequest);){
            if (!response.isSuccessful()) {
                throw new ProfileException("Unable to download scanned rules profile: " + this.error(response));
            }
            Path tmpDir = Files.createTempDirectory("", new FileAttribute[0]);
            Path tmpZip = tmpDir.resolve("repository.zip");
            try (OutputStream output = Files.newOutputStream(tmpZip, new OpenOption[0]);
                 InputStream stream = response.body().byteStream();){
                IOUtils.copy((InputStream)stream, (OutputStream)output);
                this.unzip((InputStream)new FileInputStream(tmpZip.toFile()), request.getFile());
            }
            finally {
                FileUtils.deleteQuietly((File)tmpDir.toFile());
            }
        }
        catch (IOException e) {
            throw new ProfileException("Unable to dowload repository", (Throwable)e);
        }
    }

    private void zip(File profileFile, File output) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(output));){
            int length;
            ZipEntry zipEntry = new ZipEntry(profileFile.getName());
            zos.putNextEntry(zipEntry);
            FileInputStream fis = new FileInputStream(profileFile);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zos.write(bytes, 0, length);
            }
            fis.close();
            zos.close();
        }
    }

    private void unzip(InputStream content, File profileFile) throws IOException {
        byte[] buffer = new byte[1024];
        try (ZipInputStream zis = new ZipInputStream(content);){
            int len;
            zis.getNextEntry();
            FileOutputStream fos = new FileOutputStream(profileFile);
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
        }
    }
}

