/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.api.scm;

import com.yagaan.scanner.api.project.Project;
import com.yagaan.scanner.api.scm.GitHubDetails;
import com.yagaan.scanner.api.scm.GitRepository;
import com.yagaan.scanner.api.scm.ISourceConnector;
import com.yagaan.scanner.api.scm.ISourceConnectorVisitor;
import com.yagaan.scanner.api.scm.UploadedCode;
import com.yagaan.scanner.api.settings.ConfigurationProperty;
import java.util.ArrayList;
import java.util.List;

public class SourceConfigurationPropertyBuilder
implements ISourceConnectorVisitor {
    private final Project project;
    private final List<ConfigurationProperty> properties = new ArrayList();

    public SourceConfigurationPropertyBuilder(Project project) {
        this.project = project;
    }

    public SourceConfigurationPropertyBuilder connector(ISourceConnector connector) {
        connector.accept((ISourceConnectorVisitor)this);
        return this;
    }

    public List<ConfigurationProperty> build() {
        return this.properties;
    }

    public void accept(GitHubDetails github) {
        this.properties.add(new ConfigurationProperty("pscm.github.owner", ConfigurationProperty.Kind.STRING, this.project.getId()).value(github.getOwner()));
        this.properties.add(new ConfigurationProperty("pscm.github.repo", ConfigurationProperty.Kind.STRING, this.project.getId()).value(github.getRepo()));
        this.properties.add(new ConfigurationProperty("pscm.github.branch", ConfigurationProperty.Kind.STRING, this.project.getId()).value(github.getBranch()));
    }

    public void accept(GitRepository git) {
        this.properties.add(new ConfigurationProperty("pscm.git.url", ConfigurationProperty.Kind.STRING, this.project.getId()).value(git.getUrl()));
        this.properties.add(new ConfigurationProperty("pscm.git.branch", ConfigurationProperty.Kind.STRING, this.project.getId()).value(git.getBranch()));
        this.properties.add(new ConfigurationProperty("pscm.git.id", ConfigurationProperty.Kind.STRING, this.project.getId()).value(git.getSshIdentity()));
    }

    public void accept(UploadedCode upload) {
        this.properties.add(new ConfigurationProperty("pscm.upload.file", ConfigurationProperty.Kind.FILE, this.project.getId()).file(upload.getFile()));
    }
}

