/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.cli;

import com.google.common.base.Preconditions;
import com.yagaan.scanner.api.gates.ScanGate;
import com.yagaan.scanner.scan.AbstractScannerProperties;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;

public class CommandLineScannerProperties
extends AbstractScannerProperties {
    private final Path path;
    private boolean waitCompletion;
    private ScanGate scanGateOverride;
    private List<Path> compileCommandsPaths;
    private List<Path> whiteListFolders;
    private Set<String> includedExtensions;
    private boolean sendAllExternalHeaders;

    public CommandLineScannerProperties(Path path) {
        Preconditions.checkArgument((path.isAbsolute() && path.normalize().equals(path) ? 1 : 0) != 0);
        this.path = path;
    }

    public void setSkip(boolean skip) {
    }

    public boolean isIgnoringBinaries() {
        return true;
    }

    public boolean isSkipping() {
        return false;
    }

    public Path getPath() {
        return this.path;
    }

    public void setWaitCompletion(boolean waitCompletion) {
        this.waitCompletion = waitCompletion;
    }

    public boolean isWaitCompletion() {
        return this.waitCompletion;
    }

    public void setScanGateOverride(ScanGate scanGateOverride) {
        this.scanGateOverride = scanGateOverride;
    }

    public ScanGate getScanGateOverride() {
        return this.scanGateOverride;
    }

    public List<Path> getCompileCommandsPaths() {
        return this.compileCommandsPaths;
    }

    public void setCompileCommandsPath(List<Path> compileCommandsPaths) {
        this.compileCommandsPaths = compileCommandsPaths;
    }

    public List<Path> getWhiteListFolders() {
        return this.whiteListFolders;
    }

    public void setWhiteListFolders(List<Path> whiteListFolders) {
        this.whiteListFolders = whiteListFolders;
    }

    public void setIncludedExtensions(Set<String> includedExtensions) {
        this.includedExtensions = includedExtensions;
    }

    public Set<String> getIncludedExtensions() {
        return this.includedExtensions;
    }

    public boolean isSendAllExternalHeaders() {
        return this.sendAllExternalHeaders;
    }

    public void setSendAllExternalHeaders(boolean sendAllExternalHeaders) {
        this.sendAllExternalHeaders = sendAllExternalHeaders;
    }
}

