/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.cli;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.yagaan.scanner.api.gates.ScanGate;
import com.yagaan.scanner.cli.CommandLineScannerProperties;
import com.yagaan.scanner.cli.YagaanScannerCli;
import com.yagaan.scanner.scan.Configuration;
import com.yagaan.scanner.scan.IScannerProperties;
import com.yagaan.scanner.scan.YagScannerLauncher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(description={"Submit the scan of a directory on a remote Yagaan Scan Service. Username, password, proxy configuration and default group can be set in .yagaan/scanner-configuration.json of the home directory."}, footer={"Copyright(c) Yagaan 2021"}, name="yag-scanner", mixinStandardHelpOptions=true, version={"yag-scanner 1.5.2"}, descriptionHeading="%n@|bold,underline Description|@:%n%n", parameterListHeading="%n@|bold,underline Parameters|@:%n", optionListHeading="%n@|bold,underline Options|@:%n", sortOptions=false)
public class YagaanScannerCli
implements Callable<Void> {
    private static final ImmutableSet<String> C_CPP_FILE_EXTENSIONS = ImmutableSet.of((Object)"c", (Object)"i", (Object)"ii", (Object)"cpp", (Object)"h", (Object)"cxx", (Object[])new String[]{"cc", "hpp", "cp", "CPP", "c++", "C", "hh", "H"});
    public static final String VERSION = "1.5.2";
    private final Logger logger = LoggerFactory.getLogger(YagaanScannerCli.class);
    @CommandLine.Option(names={"-s", "--server"}, description={"URL of the Yagaan Scan Service  (default: https://scan.yagaan.io)"})
    private String url;
    @CommandLine.Option(names={"-n", "--name"}, description={"Scanned project name (default: current directory name)"})
    private String projectName;
    @CommandLine.Option(names={"-u", "--username"}, description={"Username"})
    private String username;
    @CommandLine.Option(names={"-p", "--password"}, description={"Password"}, interactive=true)
    private String password;
    @CommandLine.Option(names={"-t", "--token"}, description={"Personal Access Token to be used instead of username and password"})
    private String token;
    @CommandLine.Option(names={"-g", "--group"}, description={"Group name  (default: first group of the user)"}, interactive=true)
    private String group;
    @CommandLine.Option(names={"-ph", "--proxy-host"}, description={"Proxy host (e.g.: 192.168.0.10, proxy.localdomain)"})
    private String proxyHost;
    @CommandLine.Option(names={"-pp", "--proxy-port"}, description={"Proxy port (default: 80)"})
    private String proxyPort;
    @CommandLine.Option(names={"-pu", "--proxy-username"}, description={"Username for proxy authentication"})
    private String proxyUser;
    @CommandLine.Option(names={"-ppw", "--proxy-password"}, description={"Password for proxy authentication"}, interactive=true)
    private String proxyPassword;
    @CommandLine.Option(names={"-w", "--wait-for-completion"}, description={"Wait for scan completion on the Yagaan Scan Service and return a non-zero status if the result of the scan does not meet the security gate definition, if any", "The security gate may be defined on the Yagaan Scan Service but also overridden using @|yellow --sg-score|@, @|yellow --sg-high|@, @|yellow --sg-medium|@ and @|yellow --sg-low|@ options"})
    private boolean waitCompletion;
    @CommandLine.Option(names={"--sg-risk"}, defaultValue="-1", description={"Maximum security risk the project must respect to pass the security gate. Overrides the server definition, if any.", "Only valid if option @|yellow --wait-for-completion|@ is also provided"})
    private int maxRisk;
    @CommandLine.Option(names={"--sg-high"}, defaultValue="-1", description={"Maximum number of high vulnerabilities the project can have to pass the security gate. Overrides the server definition, if any.", "Only valid if option @|yellow --wait-for-completion|@ is also provided"})
    private int maxHigh;
    @CommandLine.Option(names={"--sg-medium"}, defaultValue="-1", description={"Maximum number of medium vulnerabilities the project can have to pass the security gate. Overrides the server definition, if any.", "Only valid if option @|yellow --wait-for-completion|@ is also provided"})
    private int maxMedium;
    @CommandLine.Option(names={"--sg-low"}, defaultValue="-1", description={"Maximum number of low vulnerabilities the project can have to pass the security gate. Overrides the server definition, if any.", "Only valid if option @|yellow --wait-for-completion|@ is also provided"})
    private int maxLow;
    @CommandLine.Option(names={"--extensions"}, description={"Extensions of files that should be included. You may specified this option several times and provide comma separated lists of extensions.", "Some common extensions are included by default and you may add your own extension, for example because the project to analyse uses uncommon extension (e.g., .javascript for JS files)"})
    private List<String> includedExtensions;
    @CommandLine.Option(names={"--print-extensions"}, description={"Print extensions of files that will be archived and sent to the server (unless stored in a folder starting with '.')."})
    private boolean printIncludedExtensions;
    @CommandLine.Option(names={"-cc", "--compile-commands"}, paramLabel="path", description={"Path to the compile_commands.json file.", "This option may be specified several times if there are several files.", "All necessary compile_commands.json files should be specified.", "These files are required for C/C++ projects. If none are specified, they may be searched for in the project folder depending on @|yellow --search-compile-commands|@."})
    private List<File> compileCommands;
    @CommandLine.Option(names={"--search-compile-commands"}, paramLabel="true|false", arity="1", defaultValue="true", description={"Specify if compile_commands.json file should be searched for in the project folder (recursively) if none are specified using @|yellow --compile-commands|@.", "This option is true by default, but ignored if @|yellow --compile-commands|@ is also provided.", "The compile_commands.json files are required for C/C++ projects."})
    private boolean searchCompileCommands;
    @CommandLine.Option(names={"--send-all-external-headers"}, paramLabel="true|false", arity="1", defaultValue="false", description={"If set to true, then all folders explicitly or implicity on the include path should be sent (if allowed, see @|yellow --allow-access|@). If set to false, then only the files that have been detected as used by the project are sent.", "The default value is false.", "This option can be usefull if the automatic detection fails to detect that some files are used by the project: any folder outside the project but explicity referenced in the compile_command.json file (for example with -I) would be copied and sent along the project to the server."})
    private boolean sendAllExternalHeaders;
    @CommandLine.Option(names={"-a", "--allow-access"}, paramLabel="path", description={"Allow this program to send resources (for example C/C++ header files) referenced in the project (for example in compile_commands.json) to the scan server if at the given path or in a sub-folder of the given path.", "This option may be specified multiple time to allow several paths. If this option is not specified then only /usr/include and /usr/local/include are allowed."})
    private List<File> whiteListFolder;
    @CommandLine.Option(names={"-q", "--query"}, description={"Run a Yagaan Query Language (YQL) query and print results"})
    private String query;
    @CommandLine.Parameters(index="0", description={"The directory to scan"})
    private File directory;

    public static void main(String[] args) throws Exception {
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.AUTO;
        YagaanScannerCli cli = new YagaanScannerCli();
        CommandLine cmd = new CommandLine((Object)cli);
        1 exceptionHandler = new /* Unavailable Anonymous Inner Class!! */;
        cmd.parseWithHandlers((CommandLine.IParseResultHandler2)((CommandLine.AbstractParseResultHandler)new CommandLine.RunLast().useOut(System.out)).useAnsi(ansi), (CommandLine.IExceptionHandler2)((CommandLine.DefaultExceptionHandler)exceptionHandler.useErr(System.err)).useAnsi(ansi), args);
    }

    @Override
    public Void call() throws Exception {
        if (this.printIncludedExtensions) {
            this.printIncludedExtensions(System.out);
        }
        YagScannerLauncher launcher = new YagScannerLauncher(this.buildScannerProperties(), this.logger);
        launcher.launch();
        return null;
    }

    private IScannerProperties buildScannerProperties() {
        Path path = this.directory == null ? Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath().normalize() : (this.directory.isAbsolute() ? this.directory.toPath().normalize() : Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath().resolve(this.directory.toPath()).normalize());
        if (!path.toFile().exists()) {
            throw new IllegalStateException(new FileNotFoundException(path.toString()));
        }
        if (this.token != null && this.username != null) {
            throw new IllegalArgumentException("Personal Access Token and username cannot be both provided");
        }
        CommandLineScannerProperties properties = new CommandLineScannerProperties(path);
        properties.setPropertyIfEmpty("yagaan.username", this.token);
        properties.setPropertyIfEmpty("yagaan.password", this.token);
        properties.setPropertyIfEmpty("yagaan.username", this.username);
        properties.setPropertyIfEmpty("yagaan.password", this.password);
        properties.setPropertyIfEmpty("yagaan.url", this.url);
        properties.setPropertyIfEmpty("yagaan.group", this.group);
        properties.setPropertyIfEmpty("yagaan.proxyHost", this.proxyHost);
        properties.setPropertyIfEmpty("yagaan.proxyPort", this.proxyPort);
        properties.setPropertyIfEmpty("yagaan.proxyUser", this.proxyUser);
        properties.setPropertyIfEmpty("yagaan.proxyPassword", this.proxyPassword);
        properties.setPropertyIfEmpty("yagaan.query", this.query);
        String pname = this.projectName;
        if (pname == null) {
            pname = path.getFileName().toString();
        }
        properties.setPropertyIfEmpty("yagaan.projectName", pname);
        properties.setIncludedExtensions(this.getIncludedExtensions());
        properties.setCompileCommandsPath((List)this.getCompileCommandsPaths(path));
        properties.setWhiteListFolders((List)this.getWhiteListFolders());
        properties.setSendAllExternalHeaders(this.sendAllExternalHeaders);
        properties.setWaitCompletion(this.waitCompletion);
        if (this.maxRisk != -1 || this.maxHigh != -1 || this.maxMedium != -1 || this.maxLow != -1) {
            ScanGate scanGateOverride = new ScanGate();
            scanGateOverride.setMaxScore(this.maxRisk);
            scanGateOverride.setMaxHigh(this.maxHigh);
            scanGateOverride.setMaxModerate(this.maxMedium);
            scanGateOverride.setMaxLow(this.maxLow);
            properties.setScanGateOverride(scanGateOverride);
        }
        properties.setPropertiesIfEmpty(Configuration.environmentConfiguration());
        properties.setPropertiesIfEmpty(Configuration.userGlobalConfiguration());
        return properties;
    }

    private ImmutableList<Path> getCompileCommandsPaths(Path projectRoot) {
        if (this.compileCommands != null && !this.compileCommands.isEmpty()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (File ccCandidate : this.compileCommands) {
                if (!ccCandidate.canRead()) {
                    this.logger.warn("Cannot read file " + ccCandidate + ". Ignoring it...");
                    continue;
                }
                if (!ccCandidate.toPath().toAbsolutePath().startsWith(projectRoot)) {
                    this.logger.warn("Compile commands file " + ccCandidate + " is not in project folder. Ignoring it...");
                    continue;
                }
                builder.add((Object)ccCandidate.toPath().toAbsolutePath());
            }
            ImmutableList ccFiles = builder.build();
            if (ccFiles.isEmpty() && this.hasCorCppFiles(projectRoot)) {
                this.logger.warn("The project seem to contains C or C++ files, but no valid compile_commands.json file.");
                this.logger.warn("A compile_commands.json file is mandatory to ensure proper interpretation of C/C++ source files.");
            }
            return ccFiles;
        }
        if (this.searchCompileCommands) {
            ImmutableList.Builder builder = ImmutableList.builder();
            try (Stream<Path> candidates = Files.walk(projectRoot, new FileVisitOption[0]);){
                Path ccName = Paths.get("compile_commands.json", new String[0]);
                candidates.filter(p -> p.getFileName().endsWith(ccName)).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(Files::isReadable).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            }
            catch (IOException e) {
                this.logger.warn("An error occured while looking for compile_commands.json: some files may be missing.", (Throwable)e);
            }
            ImmutableList ccFiles = builder.build();
            if (ccFiles.isEmpty() && this.hasCorCppFiles(projectRoot)) {
                this.logger.warn("The project seem to contains C or C++ files, but no valid compile_commands.json file.");
                this.logger.warn("A compile_commands.json file is mandatory to ensure proper interpretation of C/C++ source files.");
            }
            return ccFiles;
        }
        return ImmutableList.of();
    }

    private boolean hasCorCppFiles(Path projectRoot) {
        boolean bl;
        block8: {
            Stream<Path> paths = Files.walk(projectRoot, new FileVisitOption[0]);
            try {
                bl = paths.map(p -> FilenameUtils.getExtension((String)p.getFileName().toString())).anyMatch(arg_0 -> ((ImmutableSet)C_CPP_FILE_EXTENSIONS).contains(arg_0));
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.logger.warn("An error occured while looking for potential C/C++ files", (Throwable)e);
                    return false;
                }
            }
            paths.close();
        }
        return bl;
    }

    private ImmutableList<Path> getWhiteListFolders() {
        Path usrLocalPath;
        if (this.whiteListFolder != null && !this.whiteListFolder.isEmpty()) {
            return ImmutableList.copyOf((Collection)this.whiteListFolder.stream().map(f -> f.toPath().toAbsolutePath()).collect(Collectors.toList()));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        Path usrPath = Paths.get("/usr/include", new String[0]);
        if (Files.isDirectory(usrPath, new LinkOption[0])) {
            builder.add((Object)usrPath);
        }
        if (Files.isDirectory(usrLocalPath = Paths.get("/usr/local/include", new String[0]), new LinkOption[0])) {
            builder.add((Object)usrLocalPath);
        }
        return builder.build();
    }

    private Set<String> getIncludedExtensions() {
        ImmutableSet.Builder extensions = ImmutableSet.builder();
        Splitter splitter = Splitter.on((char)',').trimResults();
        Properties properties = new Properties();
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("extensions.properties");){
            if (in == null) {
                this.logger.warn("Unable to load default zipped files extensions");
            } else {
                properties.load(in);
                for (Object value : properties.values()) {
                    for (String ext : splitter.split((CharSequence)value.toString())) {
                        extensions.add((Object)ext);
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.warn("Unable to load default zipped files extensions", (Throwable)e);
        }
        if (this.includedExtensions != null) {
            for (String value : this.includedExtensions) {
                for (String ext : splitter.split((CharSequence)value)) {
                    extensions.add((Object)ext.substring(ext.lastIndexOf(46) + 1));
                }
            }
        }
        return extensions.build();
    }

    protected void printIncludedExtensions(PrintStream out) {
        List sortedCopy = Ordering.natural().sortedCopy((Iterable)this.getIncludedExtensions());
        out.println("Files with the following extensions will be considered for inclusion in the archive sent to the scanner:");
        out.print("  - ");
        out.println(String.join((CharSequence)"\n  - ", sortedCopy));
    }

    static /* synthetic */ boolean access$000(YagaanScannerCli x0) {
        return x0.printIncludedExtensions;
    }
}

