/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.http;

import com.yagaan.scanner.http.HttpConnector;
import com.yagaan.scanner.http.YagaanAuthenticator;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Challenge;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class HttpConnector {
    public static final int DEFAULT_CONNECT_TIMEOUT_SECONDS = 30;
    public static final int DEFAULT_READ_TIMEOUT_SECONDS = 60;
    private final HttpUrl url;
    private final OkHttpClient httpClient;
    private YagaanAuthenticator authenticator;

    private HttpConnector(ConnectorBuilder builder) {
        OkHttpClient.Builder httpBuilder = new OkHttpClient.Builder();
        httpBuilder.connectTimeout(30L, TimeUnit.SECONDS);
        httpBuilder.readTimeout(30L, TimeUnit.SECONDS);
        if (builder.getToken() != null) {
            this.authenticator = new YagaanAuthenticator(builder.getToken());
            httpBuilder.authenticator((Authenticator)this.authenticator);
        }
        if (builder.getProxy() != null) {
            httpBuilder.proxy(builder.getProxy());
            if (builder.getProxyUser() != null || builder.getProxyPassword() != null) {
                if (builder.getProxyUser() == null || builder.getProxyPassword() == null) {
                    throw new IllegalStateException("Both proxy user and password should be provided (or none at all)");
                }
                httpBuilder.proxyAuthenticator((route, response) -> {
                    if (response.request().header("Proxy-Authorization") != null) {
                        return null;
                    }
                    for (Challenge challenge : response.challenges()) {
                        if (!challenge.scheme().equalsIgnoreCase("OkHttp-Preemptive")) continue;
                        String authToken = Credentials.basic((String)builder.getProxyUser(), (String)builder.getProxyPassword());
                        return response.request().newBuilder().header("Proxy-Authorization", authToken).build();
                    }
                    return null;
                });
            }
        }
        this.url = HttpUrl.get((String)(builder.getUrl().endsWith("/") ? builder.getUrl() : builder.getUrl() + "/"));
        httpBuilder.connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.CLEARTEXT));
        if (this.url.isHttps() && builder.getTrustManager() != null) {
            TrustManager[] trustAllCerts = new TrustManager[]{builder.getTrustManager()};
            try {
                SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                httpBuilder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
                httpBuilder.hostnameVerifier((hostname, session) -> hostname.equals(this.url.host()));
            }
            catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
                // empty catch block
            }
        }
        this.httpClient = httpBuilder.build();
    }

    public Response call(Request request) {
        Call call = this.httpClient.newCall(request);
        try {
            return call.execute();
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to request " + request.url(), e);
        }
    }

    public void authenticate(Request.Builder request) {
        if (this.authenticator != null) {
            this.authenticator.authenticate(request);
        }
    }

    public HttpUrl.Builder url(String link) {
        if (!link.isEmpty() && link.charAt(0) == '/') {
            return this.url.newBuilder(link.substring(1));
        }
        return this.url.newBuilder(link);
    }
}

