/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.scan;

import com.yagaan.scanner.scan.Configuration;
import com.yagaan.scanner.scan.IScannerProperties;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractScannerProperties
implements IScannerProperties {
    public static final String USERNAME = "yagaan.username";
    public static final String PASSWORD = "yagaan.password";
    public static final String URL = "yagaan.url";
    public static final String PROXY_HOST = "yagaan.proxyHost";
    public static final String PROXY_PORT = "yagaan.proxyPort";
    public static final String PROXY_USER = "yagaan.proxyUser";
    public static final String PROXY_PASSWORD = "yagaan.proxyPassword";
    public static final String GROUP = "yagaan.group";
    public static final String PROJECT = "yagaan.projectName";
    public static final String QUERY = "yagaan.query";
    protected Map<String, String> properties = new HashMap();

    public void setPropertyIfEmpty(String key, String value) {
        if (value != null) {
            this.properties.putIfAbsent(key, value);
        }
    }

    public void setPropertiesIfEmpty(Configuration conf) {
        this.setPropertyIfEmpty(GROUP, conf.getGroup());
        this.setPropertyIfEmpty(URL, conf.getUrl());
        this.setPropertyIfEmpty(PASSWORD, conf.getPassword());
        this.setPropertyIfEmpty(USERNAME, conf.getUsername());
        this.setPropertyIfEmpty(PROXY_HOST, conf.getProxyHost());
        if (conf.getProxyPort() != null) {
            this.setPropertyIfEmpty(PROXY_PORT, Integer.toString(conf.getProxyPort()));
        }
        this.setPropertyIfEmpty(PROXY_USER, conf.getProxyUser());
        this.setPropertyIfEmpty(PROXY_PASSWORD, conf.getProxyPassword());
    }

    protected void putAll(Properties src, Map<String, String> properties) {
        for (String name : src.stringPropertyNames()) {
            properties.put(name, src.getProperty(name));
        }
    }

    public String getQuery() {
        return (String)this.properties.get(QUERY);
    }

    public String getUsername() {
        return (String)this.properties.get(USERNAME);
    }

    public String getPassword() {
        return (String)this.properties.get(PASSWORD);
    }

    public String getServerUrl() {
        return (String)this.properties.get(URL);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getGroupName() {
        return (String)this.properties.get(GROUP);
    }

    public String getProjectName() {
        return (String)this.properties.get(PROJECT);
    }

    public InetSocketAddress getProxy() {
        String host = (String)this.properties.get(PROXY_HOST);
        if (host != null) {
            String port = (String)this.properties.get(PROXY_PORT);
            try {
                return new InetSocketAddress(InetAddress.getByName(host), port == null ? 80 : Integer.parseInt(port));
            }
            catch (NumberFormatException | UnknownHostException e) {
                throw new IllegalStateException("Invalid proxy configuration", e);
            }
        }
        return null;
    }

    public String getProxyUser() {
        return (String)this.properties.get(PROXY_USER);
    }

    public String getProxyPassword() {
        return (String)this.properties.get(PROXY_PASSWORD);
    }
}

