/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.scan;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.yagaan.compilecommands.AbstractCompileCommand;
import com.yagaan.compilecommands.CompileCommandDTO;
import com.yagaan.compilecommands.CompileCommandsCache;
import com.yagaan.compilecommands.HeaderCCGenerator;
import com.yagaan.compilecommands.ISystemIncludesCache;
import com.yagaan.compilecommands.Relocator;
import com.yagaan.compilecommands.SystemIncludesCache;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompileCommandsRelocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompileCommandsRelocator.class);
    private final Path projectRoot;
    private final List<Path> whiteListFolders;
    private final Path copyTarget;
    private final Path yagaanTarget;
    private final ISystemIncludesCache sysPathCache;
    private final LoadingCache<Path, String> relocatedSysPath;
    private final boolean copyAllExternalHeaders;
    private final Set<Path> foldersWithForbiddenCopies;

    public CompileCommandsRelocator(Path projectRoot, List<Path> whiteListFolders, boolean copyAllExternalHeaders) {
        this.projectRoot = projectRoot;
        this.whiteListFolders = whiteListFolders;
        this.copyAllExternalHeaders = copyAllExternalHeaders;
        this.yagaanTarget = Relocator.getTargetPath((Path)projectRoot);
        this.copyTarget = this.yagaanTarget.resolve("compile_commands_files");
        this.sysPathCache = new SystemIncludesCache();
        this.relocatedSysPath = CacheBuilder.newBuilder().build(CacheLoader.from(p -> this.relocatable(null, this.copy(null, p.toString()))));
        this.foldersWithForbiddenCopies = new HashSet();
    }

    public Collection<Path> relocateCompileCommands(List<Path> ccFiles) {
        this.foldersWithForbiddenCopies.clear();
        Iterator<Path> ccfilesIt = ccFiles.iterator();
        while (ccfilesIt.hasNext()) {
            Path ccFile2 = ccfilesIt.next();
            if (!ccFile2.toFile().exists()) {
                LOGGER.warn("File " + ccFile2 + " does not exist. Ignoring it...");
                ccfilesIt.remove();
                continue;
            }
            if (!ccFile2.toFile().isFile()) {
                LOGGER.warn(ccFile2 + " should be a file. Ignoring it...");
                ccfilesIt.remove();
                continue;
            }
            if (ccFile2.toFile().canRead()) continue;
            LOGGER.warn("Cannot read " + ccFile2 + ". Ignoring it...");
            ccfilesIt.remove();
        }
        CompileCommandsCache ccCache = new CompileCommandsCache(this.projectRoot, Optional.of(ccFiles));
        ccFiles.parallelStream().forEach(arg_0 -> ((CompileCommandsCache)ccCache).loadCompileCommand(arg_0));
        ccCache.removeNonExistingFile();
        HeaderCCGenerator ccGenerator = new HeaderCCGenerator(this.projectRoot, ccCache, this.sysPathCache);
        ccGenerator.generateCompileCommands4Headers(ccCache.getKnownSources());
        Set externalIncludes = ccGenerator.getExternalIncludes();
        this.foldersWithForbiddenCopies.addAll(this.copyExternalHeadersIfAllowed(externalIncludes));
        AtomicInteger i = new AtomicInteger();
        ConcurrentHashMap ccLocations = new ConcurrentHashMap(ccFiles.size());
        ccFiles.parallelStream().forEach(ccFile -> this.relocateCompileCommandsFile(ccFile, ccCache, i, ccLocations));
        if (!ccLocations.isEmpty()) {
            Path indexFile = Relocator.getIndexFile((Path)this.yagaanTarget);
            try (BufferedWriter out = Files.newBufferedWriter(indexFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
                gson.toJson(ccLocations, new /* Unavailable Anonymous Inner Class!! */.getType(), (Appendable)out);
            }
            catch (JsonIOException | IOException e) {
                throw new RuntimeException("Error while serializing the index of compile_commands.json files to " + indexFile, e);
            }
        }
        ArrayList<Path> currentSources = new ArrayList<Path>();
        for (Path ccFile3 : ccFiles) {
            for (AbstractCompileCommand command : ccCache.getFileContent(ccFile3)) {
                currentSources.add(command.getFile());
            }
        }
        try {
            if (Files.exists(this.copyTarget, new LinkOption[0])) {
                Files.walk(this.copyTarget, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(currentSources::add);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (!this.foldersWithForbiddenCopies.isEmpty()) {
            ArrayList foldersWithForbiddenCopies = new ArrayList(this.foldersWithForbiddenCopies);
            foldersWithForbiddenCopies.sort(Comparator.naturalOrder());
            StringBuilder msg = new StringBuilder();
            msg.append("Some ");
            if (foldersWithForbiddenCopies.size() == 1) {
                msg.append("directory was");
            } else {
                msg.append("directories were");
            }
            msg.append(" referenced in a compile_commands.json but access to the ");
            if (foldersWithForbiddenCopies.size() == 1) {
                msg.append("directory");
            } else {
                msg.append("directories");
            }
            msg.append(" is not granted. See --allow-access option of the command line. ");
            if (foldersWithForbiddenCopies.size() == 1) {
                msg.append("Directory : ").append(foldersWithForbiddenCopies.get(0));
            } else {
                msg.append("Directories : ");
                foldersWithForbiddenCopies.forEach(dir -> msg.append("\n  - ").append(dir.toString()));
            }
            LOGGER.warn(msg.toString());
        }
        return currentSources;
    }

    private void relocateCompileCommandsFile(Path ccFile, CompileCommandsCache ccCache, AtomicInteger i, ConcurrentHashMap<String, String> ccLocations) {
        Collection compileCommands = ccCache.getFileContent(ccFile);
        ArrayList<CompileCommandDTO> newCompileCommands = new ArrayList<CompileCommandDTO>(compileCommands.size());
        for (AbstractCompileCommand cc : compileCommands) {
            try {
                if (cc.getLanguage() == AbstractCompileCommand.Language.OTHER) continue;
                newCompileCommands.add(this.relocateCompileCommand(ccFile, cc));
            }
            catch (RuntimeException e) {
                LOGGER.warn("Failed to adapt compile command for file {} in {}. Reason: {}. Ignoring this command.", new Object[]{cc.getFile(), ccFile, e.getMessage()});
            }
        }
        if (!newCompileCommands.isEmpty()) {
            String newCCFileName = "compile_commands_" + i.incrementAndGet() + ".json";
            Path newCCPath = this.yagaanTarget.resolve(newCCFileName);
            try {
                Files.createDirectories(this.yagaanTarget, new FileAttribute[0]);
            }
            catch (IOException e) {
                String msg = "Error while creating directory " + this.yagaanTarget + ". Ignoring file " + ccFile + ".";
                LOGGER.error(msg, (Throwable)e);
                return;
            }
            try (BufferedWriter out = Files.newBufferedWriter(newCCPath, StandardCharsets.UTF_8, new OpenOption[0]);){
                Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
                gson.toJson(newCompileCommands, new /* Unavailable Anonymous Inner Class!! */.getType(), (Appendable)out);
            }
            catch (IOException e) {
                LOGGER.error("Error while serializing the translation of " + ccFile + " to " + newCCPath + ". Ignoring this file.", (Throwable)e);
                return;
            }
            ccLocations.put(newCCFileName, this.relocatable(newCCPath, ccFile.toString()));
        }
    }

    protected CompileCommandDTO relocateCompileCommand(Path ccFile, AbstractCompileCommand cc) {
        CompileCommandDTO newCC;
        Path directory = cc.getDirectory().normalize();
        if (!directory.startsWith(this.projectRoot)) {
            throw new IllegalArgumentException("Project root should contain the directories referenced in compile_commands.json, i.e., " + directory.toString());
        }
        String newFile = this.relocatable(directory, this.copyLibsIfNeeded(directory, cc.getFile().toString()));
        String newDirectory = this.relocatable(ccFile.getParent(), cc.getDirectory().toString());
        if (cc.getCompiler() != null) {
            StringBuilder newCommand = new StringBuilder();
            newCommand.append(cc.getCompiler().toString());
            for (Path sysInclude : this.sysPathCache.getSystemIncludes(cc.getLanguage(), cc.getCompiler())) {
                String sysInc = (String)this.relocatedSysPath.getUnchecked((Object)sysInclude);
                newCommand.append(" -isystem ").append(sysInc);
            }
            for (int i = 1; i < cc.getArguments().size(); ++i) {
                newCommand.append(' ');
                String option = ((AbstractCompileCommand.Argument)cc.getArguments().get(i)).toString();
                this.relocateOption(directory, newCommand, option);
            }
            newCC = new CompileCommandDTO(newDirectory, newCommand.toString(), newFile, new ArrayList());
        } else {
            newCC = new CompileCommandDTO(newDirectory, null, newFile, new ArrayList());
        }
        return newCC;
    }

    private void relocateOption(Path directory, StringBuilder newCommand, String option) {
        if (!option.startsWith("-")) {
            String newFile = this.copyLibsIfNeeded(directory, option);
            newCommand.append(this.relocatable(directory, newFile));
            return;
        }
        if (option.indexOf(44) > 0) {
            boolean first = true;
            for (String subOption : option.split(",")) {
                if (first) {
                    first = false;
                } else {
                    newCommand.append(',');
                }
                this.relocateOption(directory, newCommand, subOption);
            }
            return;
        }
        int eq = option.indexOf(61);
        if (eq > 0) {
            newCommand.append(option.substring(0, eq + 1));
            String arg = option.substring(eq + 1);
            newCommand.append(this.relocatable(directory, this.copyLibsIfNeeded(directory, arg)));
            return;
        }
        for (String knownOption : AbstractCompileCommand.Argument.OPTIONS_WITH_ARG) {
            if (!option.startsWith(knownOption)) continue;
            newCommand.append(knownOption);
            String arg = option.substring(knownOption.length());
            newCommand.append(this.relocatable(directory, this.copyLibsIfNeeded(directory, arg)));
            return;
        }
        if (option.length() <= 2) {
            newCommand.append(option);
            return;
        }
        int fileSeparatorIdx = option.indexOf(File.separatorChar);
        if (fileSeparatorIdx > -1) {
            String arg;
            LOGGER.warn("Option seems to contain a path but option name is unknown and path start is unknown: " + option);
            if (File.separatorChar == '\\') {
                if (fileSeparatorIdx > 2 && option.charAt(fileSeparatorIdx - 1) == ':' && CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).matches(option.charAt(fileSeparatorIdx - 2))) {
                    newCommand.append(option.substring(0, fileSeparatorIdx - 2));
                    arg = option.substring(fileSeparatorIdx - 2);
                    newCommand.append(this.relocatable(directory, this.copyLibsIfNeeded(directory, arg)));
                    return;
                }
                newCommand.append(option.replaceAll(".{2,}", ""));
                return;
            }
            newCommand.append(option.substring(0, fileSeparatorIdx));
            arg = option.substring(fileSeparatorIdx);
            newCommand.append(this.relocatable(directory, this.copyLibsIfNeeded(directory, arg)));
            return;
        }
        newCommand.append(option);
    }

    protected String copyLibsIfNeeded(Path directory, String resource) {
        Path resourcePath;
        try {
            resourcePath = Paths.get(resource, new String[0]);
        }
        catch (InvalidPathException e) {
            return resource;
        }
        return this.copyLibsIfNeeded(directory, resource, resourcePath);
    }

    protected String copyLibsIfNeeded(Path directory, String resource, Path resourcePath) {
        if (!resourcePath.isAbsolute()) {
            if (Lists.newArrayList(resourcePath.iterator()).contains(Paths.get("..", new String[0]))) {
                if ((resourcePath = directory.resolve(resourcePath).normalize()).startsWith(this.projectRoot)) {
                    return resource;
                }
                return this.copy(directory, resource);
            }
            return resource;
        }
        if (resourcePath.normalize().startsWith(this.projectRoot)) {
            return resource;
        }
        return this.copy(null, resource);
    }

    private List<Path> copyExternalHeadersIfAllowed(Set<Path> externalIncludesSet) {
        int sourceSize = externalIncludesSet.size();
        ArrayList externalIncludes = new ArrayList(sourceSize);
        externalIncludesSet.stream().filter(arg_0 -> this.copyAllowed(arg_0)).forEach(externalIncludes::add);
        Object foldersWithForbiddenCopies = externalIncludes.size() != sourceSize ? externalIncludesSet.stream().filter(p -> !this.copyAllowed(p)).map(Path::getParent).distinct().collect(Collectors.toList()) : ImmutableList.of();
        externalIncludes.sort(Comparator.naturalOrder());
        List folders = externalIncludes.stream().map(Path::getParent).distinct().collect(Collectors.toList());
        folders.sort(Comparator.naturalOrder());
        for (Path folder : folders) {
            try {
                Files.createDirectories(this.copyTarget.resolve(folder.getRoot().relativize(folder)), new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Error while copying includes");
            }
        }
        for (Path src : externalIncludes) {
            try {
                Files.copy(src, this.copyTarget.resolve(src.getRoot().relativize(src)), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to copy an external include file: ignoring it.", (Throwable)e);
            }
        }
        return foldersWithForbiddenCopies;
    }

    protected String copy(Path directory, String toCopy) {
        Path path = Paths.get(toCopy, new String[0]);
        boolean toCopyWasAbsolute = path.isAbsolute();
        Path pathToCopy = (toCopyWasAbsolute ? path : directory.resolve(path)).normalize();
        Preconditions.checkArgument((directory == null || directory.isAbsolute() && directory.startsWith(this.projectRoot) ? 1 : 0) != 0);
        Preconditions.checkArgument((!pathToCopy.startsWith(this.projectRoot) ? 1 : 0) != 0, (Object)"Cannot copy a resource already in the project");
        Preconditions.checkArgument((!this.projectRoot.startsWith(pathToCopy) ? 1 : 0) != 0, (Object)"Copying a parent directory of the project in the project is not supported");
        try {
            Path folder = Files.isDirectory(pathToCopy, new LinkOption[0]) ? pathToCopy : pathToCopy.getParent();
            Path resolved = this.copyTarget.resolve(folder.getRoot().relativize(folder));
            boolean fullyAllowed = this.copyAllowed(pathToCopy);
            Files.createDirectories(resolved, new FileAttribute[0]);
            if (this.copyAllExternalHeaders && !fullyAllowed && !this.partialCopyAllowed(pathToCopy)) {
                this.foldersWithForbiddenCopies.add(pathToCopy);
            } else if (this.copyAllExternalHeaders) {
                Files.walkFileTree(pathToCopy, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to copy some potential resource: the resource may also be missing at analysis time", (Throwable)e);
        }
        String suffix = toCopy.endsWith(File.separator) ? File.separator : "";
        Path copiedTo = this.copyTarget.resolve(pathToCopy.getRoot().relativize(pathToCopy));
        if (toCopyWasAbsolute) {
            return copiedTo.toString() + suffix;
        }
        return directory.relativize(copiedTo).toString() + suffix;
    }

    private boolean partialCopyAllowed(Path path) {
        for (Path allowed : this.whiteListFolders) {
            if (!path.startsWith(allowed) && !allowed.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    private boolean copyAllowed(Path path) {
        for (Path allowed : this.whiteListFolders) {
            if (!path.startsWith(allowed)) continue;
            return true;
        }
        return false;
    }

    protected String relocatable(Path directory, String file) {
        String prefixVar;
        Path reference;
        String suffix;
        try {
            Paths.get(file, new String[0]);
        }
        catch (InvalidPathException e) {
            return file;
        }
        Preconditions.checkArgument((boolean)this.projectRoot.normalize().equals(this.projectRoot));
        Preconditions.checkArgument((directory == null || directory.normalize().equals(directory) ? 1 : 0) != 0);
        Path filePath = Paths.get(file, new String[0]).normalize();
        if (!filePath.isAbsolute()) {
            Preconditions.checkState((boolean)directory.resolve(file).normalize().startsWith(this.projectRoot));
            if (File.separatorChar == '\\') {
                return file.replace('\\', '/');
            }
            return file;
        }
        Preconditions.checkArgument((boolean)filePath.startsWith(this.projectRoot));
        String string = suffix = file.endsWith(File.separator) ? "/" : "";
        if (filePath.equals(this.projectRoot)) {
            return "$ROOT" + suffix;
        }
        if (filePath.startsWith(this.copyTarget)) {
            reference = this.copyTarget;
            prefixVar = "CCFILES";
        } else {
            Preconditions.checkState((boolean)filePath.startsWith(this.projectRoot));
            reference = this.projectRoot;
            prefixVar = "ROOT";
        }
        Path relative = reference.relativize(filePath);
        if (File.separatorChar == '\\') {
            return "$" + prefixVar + "/" + Streams.stream((Iterable)relative).map(Path::toString).collect(Collectors.joining("/")) + suffix;
        }
        return "$" + prefixVar + "/" + relative + suffix;
    }

    static /* synthetic */ Path access$000(CompileCommandsRelocator x0) {
        return x0.copyTarget;
    }

    static /* synthetic */ boolean access$100(CompileCommandsRelocator x0, Path x1) {
        return x0.partialCopyAllowed(x1);
    }

    static /* synthetic */ Set access$200(CompileCommandsRelocator x0) {
        return x0.foldersWithForbiddenCopies;
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }

    static /* synthetic */ boolean access$400(CompileCommandsRelocator x0, Path x1) {
        return x0.copyAllowed(x1);
    }
}

