/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.scan;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    private String username = "demo";
    private String password = "demo";
    private String token;
    private String url = "https://scan.yagaan.io";
    private String group;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPassword;

    public static Configuration userGlobalConfiguration() {
        String home = System.getProperty("user.home");
        Path path = Paths.get(home, ".yagaan");
        Path confPath = path.resolve("scanner-configuration.json");
        if (confPath.toFile().exists()) {
            try {
                return (Configuration)new Gson().fromJson(FileUtils.readFileToString((File)confPath.toFile(), (Charset)Charsets.UTF_8), Configuration.class);
            }
            catch (JsonSyntaxException | IOException e) {
                LOGGER.error("Unable to read user yagaan scanner configuration", e);
            }
        }
        return new Configuration();
    }

    public static Configuration environmentConfiguration() {
        Configuration envconf = new Configuration();
        String token = Configuration.env((String)"token");
        if (token != null) {
            envconf.setUsername(token);
            envconf.setPassword(token);
        } else {
            envconf.setUsername(Configuration.env((String)"username"));
            envconf.setPassword(Configuration.env((String)"password"));
        }
        envconf.setUrl(Configuration.env((String)"url"));
        envconf.setGroup(Configuration.env((String)"group"));
        envconf.setProxyHost(Configuration.env((String)"proxy_host"));
        envconf.setProxyHost(Configuration.env((String)"proxy_port"));
        envconf.setProxyUser(Configuration.env((String)"proxy_user"));
        envconf.setProxyPassword(Configuration.env((String)"proxy_password"));
        return envconf;
    }

    private static String env(String name) {
        String p = "YAGAAN_" + name.toUpperCase();
        String v = System.getenv(p);
        if (StringUtils.isEmpty((CharSequence)v)) {
            return null;
        }
        return v;
    }

    public String getUsername() {
        return this.token != null ? this.token : this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.token = null;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getPassword() {
        return this.token != null ? this.token : this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.token = null;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
        this.username = null;
        this.password = null;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Nullable
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Nullable
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Nullable
    public String getProxyUser() {
        return this.proxyUser;
    }

    @Nullable
    public String getProxyPassword() {
        return this.proxyPassword;
    }
}

