/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.scan;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.yagaan.scanner.scan.SourceZipBuilder;
import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceZipBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceZipBuilder.class);
    private final Set<String> includedExtensions;
    private final ImmutableSet<Path> includedResources;

    public SourceZipBuilder(Set<String> includedExtensions, Collection<Path> includedResources) {
        this.includedExtensions = includedExtensions;
        this.includedResources = (ImmutableSet)includedResources.stream().filter(p -> !includedExtensions.contains(FilenameUtils.getExtension((String)p.getFileName().toString()))).collect(ImmutableSet.toImmutableSet());
    }

    public void pack(Path directory, Path zipFilePath) {
        Preconditions.checkArgument((boolean)directory.isAbsolute());
        Preconditions.checkArgument((boolean)zipFilePath.isAbsolute());
        SourcePredicate predicate = new SourcePredicate((Set)this.includedResources, this.includedExtensions, (Set)ImmutableSet.of((Object)"jar"));
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(zipFilePath, new OpenOption[0]));){
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            LOGGER.error("Unable to zip directory {}", (Object)directory, (Object)e);
        }
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

