/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.scan;

import com.yagaan.compilecommands.AbstractCompileCommand;
import com.yagaan.compilecommands.Relocator;
import com.yagaan.scanner.api.YagaanRestClient;
import com.yagaan.scanner.api.gates.ScanGate;
import com.yagaan.scanner.api.group.Group;
import com.yagaan.scanner.api.project.Project;
import com.yagaan.scanner.api.project.ProjectService;
import com.yagaan.scanner.api.project.QueryResults;
import com.yagaan.scanner.api.project.Summary;
import com.yagaan.scanner.api.project.UploadProjectRequest;
import com.yagaan.scanner.api.scm.ISourceConnector;
import com.yagaan.scanner.api.scm.UploadedCode;
import com.yagaan.scanner.api.scm.UploadedFile;
import com.yagaan.scanner.scan.CompileCommandsRelocator;
import com.yagaan.scanner.scan.IScannerProperties;
import com.yagaan.scanner.scan.ScanRequest;
import com.yagaan.scanner.scan.ScanStatus;
import com.yagaan.scanner.scan.SecurityGateException;
import com.yagaan.scanner.scan.SourceZipBuilder;
import com.yagaan.scanner.scan.YagScannerLauncher;
import com.yagaan.scanner.utils.Counter;
import com.yagaan.scanner.utils.Trend;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class YagScannerLauncher {
    private final IScannerProperties properties;
    private YagaanRestClient client;
    private final Logger logger;
    private final boolean querying;

    public YagScannerLauncher(IScannerProperties properties, Logger logger) {
        this.properties = properties;
        this.logger = logger;
        this.querying = properties.getQuery() != null;
    }

    public void launch() throws ConnectException {
        if (!this.querying) {
            this.logger.info("################# Yagaan Scan Configuration #################");
            this.logger.info("Scanned directory: {}", (Object)this.properties.getPath());
            this.printConfiguration();
            this.logger.info("################# Yagaan Scan ###############################");
            this.logger.info("Connecting to Yagaan Scan Service at " + this.properties.getServerUrl());
        }
        YagaanRestClient client = YagaanRestClient.Builder.newBuilder().url(this.properties.getServerUrl()).credentials(this.properties.getUsername(), this.properties.getPassword()).proxy(this.properties.getProxy()).proxyCredentials(this.properties.getProxyUser(), this.properties.getProxyPassword()).trustAll(true).build();
        this.launch(client);
    }

    private void printConfiguration() {
        for (Map.Entry e : this.properties.getProperties().entrySet()) {
            if (!((String)e.getKey()).startsWith("yagaan") || ((String)e.getKey()).contains("password") || ((String)e.getKey()).contains("username")) continue;
            this.logger.info((String)e.getKey() + "=" + (String)e.getValue());
        }
    }

    public void launch(YagaanRestClient client) {
        this.client = client;
        ScanRequest request = this.buildScanRequest();
        this.execute(request);
    }

    private void execute(ScanRequest request) {
        block17: {
            try {
                Collection<Object> cSourceFiles;
                if (!this.properties.isIgnoringBinaries()) {
                    this.checkBinaries();
                }
                String query = this.properties.getQuery();
                Project project = new Project(request.getProjectName());
                project.setGroupId(request.getGroupId());
                if (!this.querying) {
                    this.logger.info("Get/Create Scan Project '" + request.getProjectName() + "'");
                }
                ProjectService api = this.client.project();
                Project projectModel = api.getOrCreate(project);
                if (this.querying) {
                    QueryResults found = api.query(projectModel, query);
                    this.printQueryResults(found);
                    break block17;
                }
                Path targetPath = Relocator.getTargetPath((Path)this.properties.getPath());
                try {
                    if (Files.exists(targetPath, new LinkOption[0])) {
                        Files.walkFileTree(targetPath, (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
                    }
                    targetPath.toFile().mkdirs();
                }
                catch (IOException e1) {
                    this.logger.error("Failed to cleanup directory {}", (Object)targetPath, (Object)e1);
                    System.exit(1);
                }
                if (this.properties.getCompileCommandsPaths() != null) {
                    Task ccTask = new Task("compile_commands");
                    this.logger.info("Copying external resource to project directory and adapting compile_commands.json");
                    CompileCommandsRelocator ccRelocator = new CompileCommandsRelocator(this.properties.getPath(), this.properties.getWhiteListFolders(), this.properties.isSendAllExternalHeaders());
                    cSourceFiles = ccRelocator.relocateCompileCommands(this.properties.getCompileCommandsPaths());
                    this.checkCFiles(new HashSet(cSourceFiles));
                    this.logger.info("...... Done in " + ccTask.stop().duration());
                } else {
                    cSourceFiles = Collections.emptyList();
                }
                Task zip = new Task("zip");
                Path zipPath = this.getTmpZipPath();
                this.logger.info("Zipping Source Code to " + zipPath);
                new SourceZipBuilder(this.properties.getIncludedExtensions(), cSourceFiles).pack(this.properties.getPath(), zipPath);
                this.logger.info("...... Done in " + zip.stop().duration());
                Task uploadTask = new Task("upload");
                String size = FileUtils.byteCountToDisplaySize((long)zipPath.toFile().length());
                this.logger.info("Uploading " + size);
                UploadedFile upload = api.upload(new UploadProjectRequest(zipPath.toFile(), projectModel));
                api.scm(projectModel, (ISourceConnector)new UploadedCode(upload));
                this.logger.info("...... Done in " + uploadTask.stop().duration());
                if (this.properties.isWaitCompletion()) {
                    Summary summary;
                    api.setRefreshInMillis(500);
                    ProgressReporter statusListener = new ProgressReporter(this.logger);
                    ScanGate gate = this.getScanGate(api, projectModel);
                    Task scanTask = new Task("scan");
                    this.logger.info("Sending a new Scan Request");
                    try {
                        summary = api.scanWithResults(projectModel, (io.reactivex.functions.Consumer)statusListener);
                    }
                    catch (RuntimeException e) {
                        this.logger.info("...... Done in " + scanTask.stop().duration());
                        throw e;
                    }
                    this.logger.info("...... Done in " + scanTask.stop().duration());
                    this.printSummary(summary);
                    try {
                        gate.check(summary);
                    }
                    catch (SecurityGateException e) {
                        this.logger.warn("Project does not match security gate");
                        System.exit(1);
                    }
                    break block17;
                }
                Task scanTask = new Task("scan");
                this.logger.info("Sending a new Scan Request");
                ScanStatus status = api.scan(projectModel);
                this.logger.info("...... Done in " + scanTask.stop().duration());
                if (status.getState() != ScanStatus.State.REJECTED) {
                    this.logger.info("Scan has been accepted");
                } else {
                    String cause = status.getMessage() != null ? ": " + status.getMessage() : "";
                    this.logger.warn("Scan has been rejected" + cause);
                    System.exit(1);
                }
            }
            catch (RuntimeException e) {
                this.logger.debug("Error:", (Throwable)e);
                System.err.println(e.getMessage());
                System.exit(1);
            }
        }
    }

    private ScanGate getScanGate(ProjectService api, Project project) {
        ScanGate sgo = this.properties.getScanGateOverride();
        if (sgo == null || sgo.getMaxHigh() < 0 || sgo.getMaxLow() < 0 || sgo.getMaxModerate() < 0 || sgo.getMaxHigh() < 0) {
            Task gateRetrievalTask = new Task("scan gate download");
            this.logger.info("Retrieving project's default scan gate");
            Optional scanGateOpt = this.client.gate().getProjectGate(project.getId().longValue());
            ScanGate scanGate = scanGateOpt.isPresent() ? (ScanGate)scanGateOpt.get() : new ScanGate();
            this.logger.info("...... Done in " + gateRetrievalTask.stop().duration());
            if (sgo != null) {
                if (sgo.getMaxScore() >= 0) {
                    scanGate.setMaxScore(sgo.getMaxScore());
                }
                if (sgo.getMaxHigh() >= 0) {
                    scanGate.setMaxHigh(sgo.getMaxHigh());
                }
                if (sgo.getMaxModerate() >= 0) {
                    scanGate.setMaxModerate(sgo.getMaxModerate());
                }
                if (sgo.getMaxLow() >= 0) {
                    scanGate.setMaxLow(sgo.getMaxLow());
                }
            }
            return scanGate;
        }
        return sgo;
    }

    private void printQueryResults(QueryResults found) {
        System.out.println("Found " + found.getEntries().size() + " matches\n");
        for (QueryResults.QueryEntry entry : found.getEntries()) {
            System.out.print(this.grepOutputFormat(entry));
        }
    }

    private String grepOutputFormat(QueryResults.QueryEntry entry) {
        String file = entry.getFile();
        String[] lines = entry.getSourceCode().split("\r\n|\r|\n");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            int line = entry.getLine() + i;
            String end = i == 0 ? ":" + line + ":" : "-" + line + "-";
            sb.append(file).append(end).append("  ").append(lines[i]).append("\n");
        }
        return sb.toString();
    }

    private void printSummary(Summary summary) {
        this.logger.info("Project '" + summary.getProject().getName() + "' scanned successfully");
        this.logger.info("Scan summary:");
        this.logger.info("- score: " + this.toString(summary.getRisk()));
        this.logger.info("- vulnerabilities:");
        this.logger.info("  - high: " + this.toString(summary.getCritical()));
        this.logger.info("  - medium: " + this.toString(summary.getMajor()));
        this.logger.info("  - low: " + this.toString(summary.getMinor()));
        this.logger.info("- detected false positives: " + summary.getDetectedFalsePositives());
        this.logger.info("- project size (lines of code): " + this.toString(summary.getLocs()));
    }

    private String toString(Counter<Integer> counter) {
        return counter.getValue() + this.trendToString(counter.getTrend());
    }

    private String trendToString(Trend trend) {
        if (trend == Trend.INC) {
            return " (increasing)";
        }
        if (trend == Trend.DEC) {
            return " (decreasing)";
        }
        return "";
    }

    private void checkCFiles(Set<Path> cSourceFiles) {
        HashSet cLikeExtensions = Sets.newHashSet((Iterable)Iterables.concat((Iterable)AbstractCompileCommand.C_EXTENSIONS, (Iterable)AbstractCompileCommand.CPP_EXTENSIONS));
        try {
            Path projectPath = this.properties.getPath();
            Path ignorePath = Relocator.getTargetPath((Path)projectPath);
            ArrayList<Object> notUploadedFiles = new ArrayList<Object>();
            Files.walkFileTree(projectPath, (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
            if (!notUploadedFiles.isEmpty()) {
                notUploadedFiles.sort(Comparator.naturalOrder());
                StringBuilder msg = new StringBuilder();
                msg.append("Some files that look like C or C++ files are not included in the uploaded files (not referenced in the compile_commands.json files, nor in source files for header files)\n");
                notUploadedFiles.forEach((Consumer<Object>)((Consumer<String>)s -> msg.append("  - ").append((String)s).append("\n")));
                this.logger.warn(msg.toString());
            }
        }
        catch (IOException e) {
            String msg = "An exception occurred while looking for potential C/C++ source files that would not be uploaded";
            this.logger.info("An exception occurred while looking for potential C/C++ source files that would not be uploaded", (Throwable)e);
        }
    }

    private void checkBinaries() {
        try {
            HasClassFileVisitor hasClassFileVisitor = new HasClassFileVisitor(null);
            Files.walkFileTree(this.properties.getPath(), (FileVisitor<? super Path>)hasClassFileVisitor);
            if (!HasClassFileVisitor.access$100((HasClassFileVisitor)hasClassFileVisitor)) {
                this.noBinaries();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to walk into directory", e);
        }
    }

    private void noBinaries() {
        throw new IllegalStateException("No .class found into the output directory, some SAST expect that to work correctly. Please, compile the project before or ignore this using 'yagaan.binaries.ignore=true''");
    }

    private ScanRequest buildScanRequest() {
        Optional group = this.findGroup();
        if (!group.isPresent()) {
            throw new IllegalStateException("Unable to find the user's group");
        }
        String projectName = this.properties.getProjectName();
        if (!this.querying) {
            this.logger.info("Project '" + projectName + "' will be scanned into the group '" + ((Group)group.get()).getName() + "'");
        }
        return new ScanRequest(this.properties.getProjectName(), ((Group)group.get()).getId());
    }

    private Optional<Group> findGroup() {
        String groupNameFromProperties = this.properties.getGroupName();
        if (!StringUtils.isEmpty((CharSequence)groupNameFromProperties)) {
            return this.client.group().find(groupNameFromProperties);
        }
        List groups = this.client.group().groups();
        if (groups.size() > 0) {
            return Optional.of((Group)groups.get(0));
        }
        return Optional.empty();
    }

    private Path getTmpZipPath() {
        Path path = this.properties.getPath();
        String fileName = path.getFileName().toString();
        Path target = Relocator.getTargetPath((Path)path);
        target.toFile().mkdirs();
        return target.resolve(fileName + ".zip");
    }
}

