/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.utils;

import com.yagaan.scanner.utils.Page;
import com.yagaan.scanner.utils.PageRequest;
import com.yagaan.scanner.utils.Pageable;
import com.yagaan.scanner.utils.Sort;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PageImpl<T>
implements Page<T> {
    private List<T> content = new ArrayList();
    private boolean first;
    private boolean last;
    private int number;
    private int numberOfElements;
    private int size;
    private Sort sort;
    private long totalElements;
    private int totalPages;

    public void setContent(List<T> content) {
        this.content = content;
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void setNumberOfElements(int numberOfElements) {
        this.numberOfElements = numberOfElements;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setTotalElements(long totalElements) {
        this.totalElements = totalElements;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public long getTotalElements() {
        return this.totalElements;
    }

    public boolean hasNext() {
        return this.getNumber() + 1 < this.getTotalPages();
    }

    public boolean isLast() {
        return this.last;
    }

    public String toString() {
        String contentType = "UNKNOWN";
        if (this.content.size() > 0) {
            contentType = this.content.get(0).getClass().getName();
        }
        return String.format("Page %s of %d containing %s instances", this.getNumber() + 1, this.getTotalPages(), contentType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageImpl)) {
            return false;
        }
        PageImpl that = (PageImpl)obj;
        return this.totalElements == that.totalElements && super.equals(obj);
    }

    public int hashCode() {
        int result = 17;
        result += 31 * (int)(this.totalElements ^ this.totalElements >>> 32);
        return result += 31 * super.hashCode();
    }

    public int getNumber() {
        return this.number;
    }

    public int getSize() {
        return this.size;
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public boolean hasPrevious() {
        return this.getNumber() > 0;
    }

    public boolean isFirst() {
        return this.first;
    }

    public Pageable nextPageable() {
        return this.hasNext() ? new PageRequest(this.number, this.size).next() : null;
    }

    public Pageable previousPageable() {
        if (this.hasPrevious()) {
            return new PageRequest(this.number, this.size).previousOrFirst();
        }
        return null;
    }

    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    public List<T> getContent() {
        return Collections.unmodifiableList(this.content);
    }

    public Iterator<T> iterator() {
        return this.content.iterator();
    }
}

