/*
 * Decompiled with CFR 0.152.
 */
package com.yagaan.scanner.utils;

import com.yagaan.scanner.utils.Pageable;

public class PageRequest
implements Pageable {
    private final int page;
    private final int size;

    public PageRequest(int page, int size) {
        this.page = page;
        this.size = size;
    }

    public Pageable next() {
        return new PageRequest(this.getPageNumber() + 1, this.getPageSize());
    }

    public Pageable first() {
        return new PageRequest(0, this.getPageSize());
    }

    public String toString() {
        return String.format("Page request [number: %d, size %d]", this.getPageNumber(), this.getPageSize());
    }

    public int getPageNumber() {
        return this.page;
    }

    public int getPageSize() {
        return this.size;
    }

    public int getOffset() {
        return this.page * this.size;
    }

    public Pageable previousOrFirst() {
        return this.hasPrevious() ? this.previous() : this.first();
    }

    public PageRequest previous() {
        return this.getPageNumber() == 0 ? this : new PageRequest(this.getPageNumber() - 1, this.getPageSize());
    }

    public boolean hasPrevious() {
        return this.page > 0;
    }
}

